<p>This module determines the settings of your web account / server and evaluates them. 
Serious weaknesses are highlighted in red, often with a brief reference to "why is it a weakness" and "how can this weakness be addressed".
The settings can usually change only the provider, because in order to change the settings so-called root rights and / or SSH is needed.</p>

<div><u>Explanations:</u><br>
<p><i class="fa fa-times resF padd-lr10"></i> Settings incorrect or not up-to-date</p>
<p><i class="fa fa-check resT padd-lr10"></i> Settings OK</p>
<p><i class="fa fa-info padd-lr15"></i> Attitude was only evaluated, but not rated</p>
</div>

<div class="ph15"></div>

<p><b>Evaluation:</b> Shows how many weaknesses have been found in the evaluation of the server. The evaluation is carried out REALTIME, so it is displayed directly with the result being displayed.</p>

<p><b>Server-IP:</b> IP address on which your web / account is located or can be reached.</p>

<p><b>Directory path:</b> The directory path shows exactly where your web account is located on the server. Important for any installations of systems, software, apps etc.</p>

<p><b>PHP / PHP version:</b> Check if PHP is enabled and if active which version is installed. 
This information is often needed for web applications and software installations, because if the version is too old, the software to be installed usually does not work.
In general, not always the latest and most current version must be installed, but no age-old version should be used.</p>

<p><b>mod_rewrite:</b> This feature is needed by most modern websites and should be turned on.</p>

<p><b>safe_mode:</b> This feature is rarely used. If your web pages do not need this setting then this setting should be turned off.</p>

<p><b>register_globals:</b> A feature with a high security risk. This feature should be turned off in principle!</p>

<p><b>MySQL / MySQL version:</b> Check if MySQL is enabled and if active which version is installed.
This feature is required for web applications and software that include a database. Again, the version is often important.
As with PHP but usually does not always have the latest and latest version installed, but should not be used age-old version.</p>

<p><b>Server-Software:</b> Summary information about the installed server software.</p>

<p><b>Server-API:</b> Server Application Programming Interface (API) of the server.</p>

<p><b>Timeout:</b> Timeout shows the time in which a process must be completed. If the process is not completed within this time, the process is aborted. Display in seconds, e.g. 30 = 30 seconds.</p>

<p><b>Max. Memorylimit:</b> Maximum memory limit for scripts and files. Default: 128M. Should not be below 32M.</p>

<p><b>Max. Data packet:</b> Maximum allowed size of POST data. Important, if e.g. large PDF, image or video files are to be loaded onto the web by form.</p>

<p><b>Max. upload size:</b> Indicates the maximum size of the file that can be uploaded via the web page.
If this setting is e.g. on 2M, the uploaded file may not be larger than 2MB.</p>

<p><b>Serversignatur:</b> The server signature contains further information about the server.</p>

<p><b>Show more settings:</b> Read out detailed account / server settings with phpinfo ().</p>

<p><b>Note:</b> The module only evaluates important and regularly used functions as well as functions that could cause erroneous processes or that could pose a security risk due to overaging.
Further settings can be read out via phpinfo (), see "show further settings".</p>

<p class="font12">Translated by Google Translate</p>
