<?PHP 
$htaccessX='
# htaccess = optimization = Version 4.0 - copyright by Ralf Lohmann, www.Lohmann.Marketing
# Please not edit
# The file is created automatically

<FilesMatch "\.inc.php$">
deny from all
</FilesMatch>

<FilesMatch "\.inc.txt$">
deny from all
</FilesMatch>

<FilesMatch "(\.htaccess)">
Order deny,allow
Deny from all
</FilesMatch>

<IfModule mod_deflate.c>
<FilesMatch "\.(js|css|html|htm|php|xml)$">
SetOutputFilter DEFLATE
</FilesMatch>
</IfModule>

<FilesMatch "\.(ico|pdf|flv|jpg|jpeg|png|gif|js|css|swf)(\.gz)?$">
Header unset ETag
FileETag None
</FilesMatch>

<IfModule mod_expires.c>
ExpiresActive On
ExpiresDefault "access plus 1 month"
# HTML
ExpiresByType text/html "access plus 0 seconds"
# HTML components (HTCs)
ExpiresByType text/x-component "access plus 1 month"
# CSS
ExpiresByType text/css "access plus 1 month"
# Data interchange
ExpiresByType application/json "access plus 0 seconds"
ExpiresByType application/xml "access plus 0 seconds"
ExpiresByType text/xml "access plus 0 seconds"
# JavaScript
ExpiresByType application/javascript "access plus 1 month"
ExpiresByType text/javascript "access plus 1 month"
ExpiresByType application/x-javascript "access plus 1 month"
# Manifest files
ExpiresByType text/cache-manifest "access plus 0 seconds"
# Favicon (cannot be renamed!) and cursor images
ExpiresByType image/x-icon "access plus 1 week"
# Media
ExpiresByType audio/ogg "access plus 1 month"
ExpiresByType image/gif "access plus 1 month"
ExpiresByType image/jpeg "access plus 1 month"
ExpiresByType image/png "access plus 1 month"
ExpiresByType video/mp4 "access plus 1 month"
ExpiresByType video/ogg "access plus 1 month"
ExpiresByType video/webm "access plus 1 month"
</IfModule>
';
?>