<p>With this module, large parts of the design of the website can be set. 
In the following individual settings are explained. Often, however, the adjustment possibilities are self-explanatory, so that in this case we will do without an explanation, e.g. on / off need not be explained separately. 
The blue headline indicates in which area the settings are changed.
</p>

<p><b>Font:</b> The selection box contains only the fonts that can be displayed safely. 
The system also "backs up" the font by automatically including sans-serif as a replacement font.
</p>

<p><b>Extended font:</b> As an alternative to the font, a "styled" font can also be included. 
Once the extended font is used, it will be preferred to the normal font.
</p>

<p><b>Fontsize:</b> Default value for normal fonts, such as Arial is 100%, with the extended font often 120%. 
The font size is no longer specified in px (pixels) as before, but in percent, u.a. to calculate the responsive area. 
The font size e.g. for tablets and smartphones, the system automatically adjusts.<br>
Note: Do not set the value too high, because normal fonts like e.g. Arial are rather unsuitable for large sizes, as these - depending on the font - is shown as very "bold". 
For oversizes the additional area "Extreme Design" is available.
</p>

<p><b>Fontcolor:</b> With a so-called color fader the color is adjustable. 
By clicking on the input field, a small additional window opens, about which up to 16 million colors can be adjusted. 
With the cross the basic color is selected, with the fine adjustment (right outside) the desired color value is set. 
If the color value is known, this value can also be entered directly in the input field. 
Incorrect entries will correct the system for the next possible color value.
</p>

<p><b>Text alignment:</b> Function with 4 settings: left, right, centered (center) and justified. 
When delivered, the text alignment is set to full block. 
In the responsive design, the block rate is automatically set to "left" from a certain display size, otherwise the distances between the words - depending on the word - become too large.
</p>

<p><b>Word spacing:</b> With this function, the distance between the words is increased or decreased.
To zoom out, use the values with the minus sign.
</p>

<p><b>Row height:</b> With this function, the distance between the lines is increased or decreased. 
The smallest value is 100% possible, because all lower settings would push the lines together for many fonts. Default setting: 120%
</p>

<p><b>Text distance left/right:</b> In order to avoid that the text does not "stick" to the right and left of the browser window, with this function the text is indented inwards.</p>

<p><b>Design "Extreme" - Typeface and oversized headlines:</b> Design "Extreme" is a feature that allows the entire layout to be set from "normal" to "extremely large". 
Text, headlines and line height can be set via the "Size" selection fields.
</p>

<p><b>For information:</b> Extremely large fonts require special fonts. These contain different font weights (font-weight), so that even large fonts appear as normal and not as bold.</p>

<p><b>Attention:</b> The system requires a few areas - i.a. for the navigation - the font size from the basic setting, that is the value, which is under "Typeface> Font size". 
Therefore, when using Design "Extreme" always set the font size over the design "Extreme" area and not over the basic value. 
The base value should be between 100 and 120%. 
For assistance, the system automatically inserts additional information at the point which should only be changed with caution.
</p>

<p><b>Transparent cover:</b> With the transparent panel, e.g. the background or shading will be toned down. 1 is the highest value.</p>

<p><b>Repeat image:</b> 4 different settings. no-repeat means that image is displayed normally. repeat means that the image is repeated until the screen is filled.</p>

<p><b>Image fixing:</b> The image is fixed, so found in the background, so that when scrolling the image remains immovable.</p>

<p><b>Cover effect:</b> If the background image does not fill the entire area, the image effect can be stretched with the Covereffect, so that it adapts to the website size.</p>

<p><b>Text / additional blocks:</b> Each individual block can be different in color. If the block is set to "off", the colors from the system or from the design palette are used.</p>

<p><b>Distances:</b> With this module, the distances between the individual blocks and the additional areas such as sliders, picture gallery etc. can be changed. 
Please enter only numerical values here. The numerical values are px (pixels)
</p>

<p class="font12">Translated by Google Translate</p>
